IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.String_Split') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.String_Split
END
GO


CREATE FUNCTION dbo.String_Split
(
	@Input NVARCHAR(MAX),
	@Delimiter CHAR(1)
)
RETURNS @Output TABLE (Value NVARCHAR(100))
AS
BEGIN
	DECLARE @Start INT, @End INT
	SET @Start = 1

	WHILE CHARINDEX(@Delimiter, @Input, @Start) > 0
	BEGIN
		SET @End = CHARINDEX(@Delimiter, @Input, @Start)
		INSERT INTO @Output (Value) VALUES (LTRIM(RTRIM(SUBSTRING(@Input, @Start, @End - @Start))))
		SET @Start = @End + 1
	END

	INSERT INTO @Output (Value) VALUES (LTRIM(RTRIM(SUBSTRING(@Input, @Start, LEN(@Input) - @Start + 1))))
	RETURN
END
